var __extends = this.__extends || function (d, b) {
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var VisualProfiler;
(function (VisualProfiler) {
    (function (EventCategory) {
        EventCategory._map = [];
        EventCategory._map[0] = "ImageDecoding";
        EventCategory.ImageDecoding = 0;
        EventCategory._map[1] = "GC";
        EventCategory.GC = 1;
        EventCategory._map[2] = "Loading";
        EventCategory.Loading = 2;
        EventCategory._map[3] = "Rendering";
        EventCategory.Rendering = 3;
        EventCategory._map[4] = "Scripting";
        EventCategory.Scripting = 4;
        EventCategory._map[5] = "Styling";
        EventCategory.Styling = 5;
    })(VisualProfiler.EventCategory || (VisualProfiler.EventCategory = {}));
    var EventCategory = VisualProfiler.EventCategory;
    var Event = (function () {
        function Event(interval, category, uiThreadId) {
            this.details = [];
            this._interval = interval;
            this._category = category;
            this._contextThreadId = Event.getContextThreadId(interval, uiThreadId);
            this._timeSpan = new VisualProfiler.TimeSpan(VisualProfiler.TimeStamp.fromNanoseconds(interval.begin), VisualProfiler.TimeStamp.fromNanoseconds(interval.end));
            this._exclusiveTimeSpan = VisualProfiler.TimeStamp.fromNanoseconds(interval.exclusiveDuration);
        }
        Object.defineProperty(Event.prototype, "category", {
            get: function () {
                return this._category;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Event.prototype, "childrenCount", {
            get: function () {
                return this._interval.childrenCount;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Event.prototype, "contextThreadId", {
            get: function () {
                return this._contextThreadId;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Event.prototype, "hasChildren", {
            get: function () {
                return this.childrenCount > 0;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Event.prototype, "interval", {
            get: function () {
                return this._interval;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Event.prototype, "level", {
            get: function () {
                return this._interval.level;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Event.prototype, "id", {
            get: function () {
                return this._interval.id;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Event.prototype, "isExpanded", {
            get: function () {
                return this._interval.isExpanded;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Event.prototype, "exclusiveDuration", {
            get: function () {
                return this._exclusiveTimeSpan;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Event.prototype, "name", {
            get: function () {
                if(typeof this._name === "undefined") {
                    this._name = Plugin.Resources.getString(this._interval.name);
                }
                return this._name;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Event.prototype, "nameAndContext", {
            get: function () {
                return this.name + this.getThreadContext();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Event.prototype, "timeSpan", {
            get: function () {
                return this._timeSpan;
            },
            enumerable: true,
            configurable: true
        });
        Event.prototype.createDetailInfo = function (name, value, nameLocalizationKey, valueLocalizationKey) {
            var localizedValue;
            if(valueLocalizationKey) {
                localizedValue = Plugin.Resources.getString(valueLocalizationKey);
            } else {
                localizedValue = value;
            }
            var additionalInfo = {
                propertyName: name,
                propertyValue: value,
                localizedName: Plugin.Resources.getString(nameLocalizationKey),
                localizedValue: localizedValue
            };
            return additionalInfo;
        };
        Event.prototype.getCssClass = function () {
            switch(this._category) {
                case EventCategory.GC: {
                    return "dataScriptingGc";

                }
                case EventCategory.ImageDecoding: {
                    return "dataImageDecoding";

                }
                case EventCategory.Loading: {
                    return "dataLoading";

                }
                case EventCategory.Rendering: {
                    return "dataRendering";

                }
                case EventCategory.Scripting: {
                    return "dataScripting";

                }
                case EventCategory.Styling: {
                    return "dataStyling";

                }
                default: {
                    throw new Error(Plugin.Resources.getErrorString("JSPerf.1033"));

                }
            }
        };
        Event.prototype.getDescription = function () {
            return "";
        };
        Event.prototype.getDetails = function (details, isForStart) {
            return [];
        };
        Event.prototype.getEventDetailsRequestInformation = function () {
            return [];
        };
        Event.prototype.getThreadContext = function () {
            return this._contextThreadId === null ? "" : " [" + this._contextThreadId + "]";
        };
        Event.convertBooleanToYesNoLabel = function convertBooleanToYesNoLabel(value) {
            return value ? "YesLabel" : "NoLabel";
        }
        Event.convertPropagationStatus = function convertPropagationStatus(propagationStatus) {
            return propagationStatus === 1 || propagationStatus === 5 || propagationStatus === 7 ? true : false;
        }
        Event.getContextThreadId = function getContextThreadId(interval, uiThreadId) {
            if(interval.beginThreadId !== uiThreadId) {
                return interval.beginThreadId;
            }
            if(interval.endThreadId !== uiThreadId) {
                return interval.endThreadId;
            }
            return null;
        }
        return Event;
    })();
    VisualProfiler.Event = Event;    
    var AlignedBeatEvent = (function (_super) {
        __extends(AlignedBeatEvent, _super);
        function AlignedBeatEvent(interval, category, uiThreadId) {
                _super.call(this, interval, category, uiThreadId);
        }
        AlignedBeatEvent.prototype.getDescription = function () {
            return Plugin.Resources.getString("AlignedBeatEventDescription");
        };
        return AlignedBeatEvent;
    })(Event);
    VisualProfiler.AlignedBeatEvent = AlignedBeatEvent;    
    var AnimationFrameEvent = (function (_super) {
        __extends(AnimationFrameEvent, _super);
        function AnimationFrameEvent(interval, category, uiThreadId) {
                _super.call(this, interval, category, uiThreadId);
        }
        AnimationFrameEvent.prototype.getDescription = function () {
            return Plugin.Resources.getString("AnimationFrameEventDescription");
        };
        return AnimationFrameEvent;
    })(Event);
    VisualProfiler.AnimationFrameEvent = AnimationFrameEvent;    
    var CssCalculationEvent = (function (_super) {
        __extends(CssCalculationEvent, _super);
        function CssCalculationEvent(interval, category, uiThreadId) {
                _super.call(this, interval, category, uiThreadId);
        }
        CssCalculationEvent.prototype.getDescription = function () {
            return Plugin.Resources.getString("CssCalculationEventDescription");
        };
        return CssCalculationEvent;
    })(Event);
    VisualProfiler.CssCalculationEvent = CssCalculationEvent;    
    var CssParsingEvent = (function (_super) {
        __extends(CssParsingEvent, _super);
        function CssParsingEvent(interval, category, uiThreadId) {
                _super.call(this, interval, category, uiThreadId);
        }
        CssParsingEvent.prototype.getDescription = function () {
            return Plugin.Resources.getString("CssParsingEventDescription");
        };
        return CssParsingEvent;
    })(Event);
    VisualProfiler.CssParsingEvent = CssParsingEvent;    
    var DomEvent = (function (_super) {
        __extends(DomEvent, _super);
        function DomEvent(interval, category, uiThreadId) {
                _super.call(this, interval, category, uiThreadId);
        }
        Object.defineProperty(DomEvent.prototype, "nameAndContext", {
            get: function () {
                if(typeof this._nameAndContext === "undefined") {
                    this._nameAndContext = this.name + this.getThreadContext();
                    var eventName = this.getEventName();
                    if(eventName) {
                        this._nameAndContext += " (";
                        this._nameAndContext += eventName;
                        this._nameAndContext += ")";
                    }
                }
                return this._nameAndContext;
            },
            enumerable: true,
            configurable: true
        });
        DomEvent.prototype.getDescription = function () {
            return Plugin.Resources.getString("DomEventDescription");
        };
        DomEvent.prototype.getDetails = function (details, isForStartEvent) {
            var result = [];
            result.push(this.createDetailInfo("EventName", this.getEventName(), "EventNameLabel", null));
            if(details) {
                var domEventDetails = details;
                var defaultPrevented = false;
                if(domEventDetails.PropagationStatus && !isForStartEvent) {
                    defaultPrevented = Event.convertPropagationStatus(domEventDetails.PropagationStatus);
                }
                result.push(this.createDetailInfo("DefaultPrevented", domEventDetails.PropagationStatus, "DefaultPreventedLabel", Event.convertBooleanToYesNoLabel(defaultPrevented)));
            }
            return result;
        };
        DomEvent.prototype.getEventDetailsRequestInformation = function () {
            var eventDetailsRequest = [];
            eventDetailsRequest.push({
                threadId: this.interval.endThreadId,
                eventTime: this.interval.end,
                isStartRequest: false
            });
            return eventDetailsRequest;
        };
        DomEvent.prototype.getEventName = function () {
            var domEventInterval = this.interval;
            if(typeof domEventInterval.eventName !== "undefined") {
                return domEventInterval.eventName;
            }
            return null;
        };
        return DomEvent;
    })(Event);
    VisualProfiler.DomEvent = DomEvent;    
    var EvaluatingScriptEvent = (function (_super) {
        __extends(EvaluatingScriptEvent, _super);
        function EvaluatingScriptEvent(interval, category, uiThreadId) {
                _super.call(this, interval, category, uiThreadId);
        }
        Object.defineProperty(EvaluatingScriptEvent.prototype, "nameAndContext", {
            get: function () {
                if(typeof this._nameAndContext === "undefined") {
                    this._nameAndContext = this.name + this.getThreadContext();
                    if(this.isInlineScript()) {
                        this._nameAndContext += " (" + Plugin.Resources.getString("InlineScriptLabel") + ")";
                    } else {
                        var scriptUrl = this.getScriptUrl();
                        if(scriptUrl) {
                            this._nameAndContext += " (";
                            this._nameAndContext += scriptUrl;
                            this._nameAndContext += ")";
                        }
                    }
                }
                return this._nameAndContext;
            },
            enumerable: true,
            configurable: true
        });
        EvaluatingScriptEvent.prototype.getDescription = function () {
            return Plugin.Resources.getString("EvaluatingScriptEventDescription");
        };
        EvaluatingScriptEvent.prototype.getDetails = function (details, isForStartEvent) {
            var result = [];
            var scriptUrl = this.getScriptUrl();
            if(typeof scriptUrl !== "undefined") {
                result.push(this.createDetailInfo("ScriptUrl", scriptUrl, "ScriptUrlLabel", null));
            }
            var scriptPreview = this.getScriptPreview();
            if(typeof scriptPreview !== "undefined") {
                result.push(this.createDetailInfo("ContentPreview", scriptPreview, "ScriptContentPreviewLabel", null));
            }
            return result;
        };
        EvaluatingScriptEvent.prototype.getScriptUrl = function () {
            var scriptEventInterval = this.interval;
            return scriptEventInterval.url;
        };
        EvaluatingScriptEvent.prototype.getScriptPreview = function () {
            var scriptEventInterval = this.interval;
            var script = scriptEventInterval.inlineScript;
            if(script) {
                var oneLinePattern = /(\r\n|\r|\n)\s*/gm;
                script = script.replace(oneLinePattern, " ");
                script = script.trim();
            }
            return script;
        };
        EvaluatingScriptEvent.prototype.isInlineScript = function () {
            var scriptEventInterval = this.interval;
            return typeof scriptEventInterval.inlineScript !== "undefined";
        };
        return EvaluatingScriptEvent;
    })(Event);
    VisualProfiler.EvaluatingScriptEvent = EvaluatingScriptEvent;    
    var EventHandlerEvent = (function (_super) {
        __extends(EventHandlerEvent, _super);
        function EventHandlerEvent(interval, category, uiThreadId) {
                _super.call(this, interval, category, uiThreadId);
        }
        EventHandlerEvent.prototype.getDescription = function () {
            return Plugin.Resources.getString("EventHandlerEventDescription");
        };
        EventHandlerEvent.prototype.getDetails = function (details, isForStartEvent) {
            var result = [];
            var eventPhaseLabelKey;
            if(details) {
                var eventHandlerEventDetails = details;
                if(eventHandlerEventDetails.EventPhase && isForStartEvent) {
                    switch(eventHandlerEventDetails.EventPhase) {
                        case "1": {
                            eventPhaseLabelKey = "CapturingEventPhaseLabel";
                            break;

                        }
                        case "2": {
                            eventPhaseLabelKey = "AtTargetEventPhaseLabel";
                            break;

                        }
                        case "3": {
                            eventPhaseLabelKey = "BubblingEventPhaseLabel";
                            break;

                        }
                    }
                    result.push(this.createDetailInfo("EventPhase", eventHandlerEventDetails.EventPhase, "EventPhaseLabel", eventPhaseLabelKey));
                }
                if(eventHandlerEventDetails.PropagationStatus && isForStartEvent) {
                    var defaultPrevented = Event.convertPropagationStatus(details.PropagationStatus);
                    result.push(this.createDetailInfo("DefaultPrevented", eventHandlerEventDetails.PropagationStatus, "DefaultPreventedLabel", Event.convertBooleanToYesNoLabel(defaultPrevented)));
                }
                if(eventHandlerEventDetails.PropagationStatus && !isForStartEvent) {
                    var propagationStopped = Event.convertPropagationStatus(details.PropagationStatus);
                    result.push(this.createDetailInfo("PropagationStopped", eventHandlerEventDetails.PropagationStatus, "PropagationStoppedLabel", Event.convertBooleanToYesNoLabel(propagationStopped)));
                }
                if(eventHandlerEventDetails.ListenerUsesCapture && isForStartEvent) {
                    result.push(this.createDetailInfo("ListenerUsesCapture", eventHandlerEventDetails.ListenerUsesCapture, "ListenerUsesCaptureLabel", Event.convertBooleanToYesNoLabel(details.ListenerUsesCapture)));
                }
            }
            return result;
        };
        EventHandlerEvent.prototype.getEventDetailsRequestInformation = function () {
            var eventDetailsRequest = [];
            eventDetailsRequest.push({
                threadId: this.interval.beginThreadId,
                eventTime: this.interval.begin,
                isStartRequest: true
            });
            eventDetailsRequest.push({
                threadId: this.interval.endThreadId,
                eventTime: this.interval.end,
                isStartRequest: false
            });
            return eventDetailsRequest;
        };
        return EventHandlerEvent;
    })(Event);
    VisualProfiler.EventHandlerEvent = EventHandlerEvent;    
    var GarbageCollectionEvent = (function (_super) {
        __extends(GarbageCollectionEvent, _super);
        function GarbageCollectionEvent(interval, category, uiThreadId) {
                _super.call(this, interval, category, uiThreadId);
        }
        GarbageCollectionEvent.prototype.getDescription = function () {
            return Plugin.Resources.getString("GarbageCollectionEventDescription");
        };
        return GarbageCollectionEvent;
    })(Event);
    VisualProfiler.GarbageCollectionEvent = GarbageCollectionEvent;    
    var HtmlParsingEvent = (function (_super) {
        __extends(HtmlParsingEvent, _super);
        function HtmlParsingEvent(interval, category, uiThreadId) {
                _super.call(this, interval, category, uiThreadId);
        }
        HtmlParsingEvent.prototype.getDescription = function () {
            return Plugin.Resources.getString("HtmlParsingEventDescription");
        };
        return HtmlParsingEvent;
    })(Event);
    VisualProfiler.HtmlParsingEvent = HtmlParsingEvent;    
    var HtmlSpeculativeDownloadingEvent = (function (_super) {
        __extends(HtmlSpeculativeDownloadingEvent, _super);
        function HtmlSpeculativeDownloadingEvent(interval, category, uiThreadId) {
                _super.call(this, interval, category, uiThreadId);
        }
        HtmlSpeculativeDownloadingEvent.prototype.getDescription = function () {
            return Plugin.Resources.getString("HtmlSpeculativeDownloadingEventDescription");
        };
        return HtmlSpeculativeDownloadingEvent;
    })(Event);
    VisualProfiler.HtmlSpeculativeDownloadingEvent = HtmlSpeculativeDownloadingEvent;    
    var HttpRequestEvent = (function (_super) {
        __extends(HttpRequestEvent, _super);
        function HttpRequestEvent(interval, category, uiThreadId) {
                _super.call(this, interval, category, uiThreadId);
        }
        Object.defineProperty(HttpRequestEvent.prototype, "nameAndContext", {
            get: function () {
                if(typeof this._nameAndContext === "undefined") {
                    var httpRequestEventInterval = this.interval;
                    this._nameAndContext = this.name + this.getThreadContext();
                    if(typeof httpRequestEventInterval.url !== "undefined") {
                        this._nameAndContext += " (";
                        this._nameAndContext += httpRequestEventInterval.url;
                        this._nameAndContext += ")";
                    }
                }
                return this._nameAndContext;
            },
            enumerable: true,
            configurable: true
        });
        HttpRequestEvent.prototype.getDescription = function () {
            return Plugin.Resources.getString("HttpRequestEventDescription");
        };
        HttpRequestEvent.prototype.getDetails = function (details, isForStartEvent) {
            var result = [];
            if(details) {
                var httpRequestEventDetails = details;
                if(httpRequestEventDetails.AddressName && isForStartEvent) {
                    result.push(this.createDetailInfo("AddressName", httpRequestEventDetails.AddressName, "AddressNameLabel", null));
                }
                if(httpRequestEventDetails.StatusLine && !isForStartEvent) {
                    result.push(this.createDetailInfo("StatusCode", httpRequestEventDetails.StatusLine, "StatusCodeLabel", null));
                }
            }
            return result;
        };
        HttpRequestEvent.prototype.getEventDetailsRequestInformation = function () {
            var eventDetailsRequest = [];
            eventDetailsRequest.push({
                threadId: this.interval.beginThreadId,
                eventTime: this.interval.begin,
                isStartRequest: true
            });
            eventDetailsRequest.push({
                threadId: this.interval.endThreadId,
                eventTime: this.interval.end,
                isStartRequest: false
            });
            return eventDetailsRequest;
        };
        return HttpRequestEvent;
    })(Event);
    VisualProfiler.HttpRequestEvent = HttpRequestEvent;    
    var ImageDecodedEvent = (function (_super) {
        __extends(ImageDecodedEvent, _super);
        function ImageDecodedEvent(interval, category, uiThreadId) {
                _super.call(this, interval, category, uiThreadId);
        }
        Object.defineProperty(ImageDecodedEvent.prototype, "nameAndContext", {
            get: function () {
                if(typeof this._nameAndContext === "undefined") {
                    this._nameAndContext = this.name + this.getThreadContext();
                    var imageUrl = this.getImageUrl();
                    if(imageUrl) {
                        this._nameAndContext += " (";
                        this._nameAndContext += imageUrl;
                        this._nameAndContext += ")";
                    }
                }
                return this._nameAndContext;
            },
            enumerable: true,
            configurable: true
        });
        ImageDecodedEvent.prototype.getDescription = function () {
            return Plugin.Resources.getString("ImageDecodedEventDescription");
        };
        ImageDecodedEvent.prototype.getDetails = function (details, isForStartEvent) {
            var result = [];
            result.push(this.createDetailInfo("ImageUrl", this.getImageUrl(), "ImageUrlLabel", null));
            return result;
        };
        ImageDecodedEvent.prototype.getImageUrl = function () {
            var imageDecodeEventInterval = this.interval;
            if(typeof imageDecodeEventInterval.url !== "undefined") {
                return imageDecodeEventInterval.url;
            } else {
                return null;
            }
        };
        return ImageDecodedEvent;
    })(Event);
    VisualProfiler.ImageDecodedEvent = ImageDecodedEvent;    
    var LayoutEvent = (function (_super) {
        __extends(LayoutEvent, _super);
        function LayoutEvent(interval, category, uiThreadId) {
                _super.call(this, interval, category, uiThreadId);
        }
        LayoutEvent.prototype.getDescription = function () {
            return Plugin.Resources.getString("LayoutEventDescription");
        };
        return LayoutEvent;
    })(Event);
    VisualProfiler.LayoutEvent = LayoutEvent;    
    var PaintRect = (function () {
        function PaintRect(paintRect) {
            this._paintRect = paintRect;
        }
        Object.defineProperty(PaintRect.prototype, "bottom", {
            get: function () {
                return this._paintRect.bottom;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(PaintRect.prototype, "height", {
            get: function () {
                return this._paintRect.bottom - this._paintRect.top;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(PaintRect.prototype, "left", {
            get: function () {
                return this._paintRect.left;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(PaintRect.prototype, "right", {
            get: function () {
                return this._paintRect.right;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(PaintRect.prototype, "top", {
            get: function () {
                return this._paintRect.top;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(PaintRect.prototype, "width", {
            get: function () {
                return this._paintRect.right - this._paintRect.left;
            },
            enumerable: true,
            configurable: true
        });
        return PaintRect;
    })();
    VisualProfiler.PaintRect = PaintRect;    
    var PaintRectEventBase = (function (_super) {
        __extends(PaintRectEventBase, _super);
        function PaintRectEventBase(interval, category, uiThreadId) {
                _super.call(this, interval, category, uiThreadId);
            this._paintRect = PaintRectEventBase.getPaintRect(interval);
        }
        Object.defineProperty(PaintRectEventBase.prototype, "nameAndContext", {
            get: function () {
                if(typeof this._nameAndContext === "undefined") {
                    this._nameAndContext = this.name + this.getThreadContext();
                    if(this._paintRect) {
                        this._nameAndContext += " (" + this.widthByHeight + ")";
                    }
                }
                return this._nameAndContext;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(PaintRectEventBase.prototype, "paintRect", {
            get: function () {
                return this._paintRect;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(PaintRectEventBase.prototype, "widthByHeight", {
            get: function () {
                if(this._paintRect) {
                    return this._paintRect.width + "x" + this._paintRect.height;
                }
                return null;
            },
            enumerable: true,
            configurable: true
        });
        PaintRectEventBase.prototype.getDetails = function (details, isForStartEvent) {
            var result = [];
            if(this._paintRect) {
                result.push(this.createDetailInfo("Origin", this._paintRect.left + ", " + this._paintRect.top, "OriginLabel", null));
                result.push(this.createDetailInfo("Dimensions", this.widthByHeight, "DimensionsLabel", null));
            }
            return result;
        };
        PaintRectEventBase.getPaintRect = function getPaintRect(interval) {
            var paintRectInterval = interval;
            if(typeof paintRectInterval.paintRect !== "undefined" && typeof paintRectInterval.paintRect.top !== "undefined" && typeof paintRectInterval.paintRect.left !== "undefined" && typeof paintRectInterval.paintRect.right !== "undefined" && typeof paintRectInterval.paintRect.bottom !== "undefined") {
                return new PaintRect(paintRectInterval.paintRect);
            }
            return null;
        }
        return PaintRectEventBase;
    })(Event);
    VisualProfiler.PaintRectEventBase = PaintRectEventBase;    
    var PaintEvent = (function (_super) {
        __extends(PaintEvent, _super);
        function PaintEvent(interval, category, uiThreadId) {
                _super.call(this, interval, category, uiThreadId);
        }
        PaintEvent.prototype.getDescription = function () {
            return Plugin.Resources.getString("PaintEventDescription");
        };
        return PaintEvent;
    })(PaintRectEventBase);
    VisualProfiler.PaintEvent = PaintEvent;    
    var RenderLayerEvent = (function (_super) {
        __extends(RenderLayerEvent, _super);
        function RenderLayerEvent(interval, category, uiThreadId) {
                _super.call(this, interval, category, uiThreadId);
        }
        RenderLayerEvent.prototype.getDescription = function () {
            return Plugin.Resources.getString("RenderLayoutEventDescription");
        };
        return RenderLayerEvent;
    })(PaintRectEventBase);
    VisualProfiler.RenderLayerEvent = RenderLayerEvent;    
    var TimerFiredEvent = (function (_super) {
        __extends(TimerFiredEvent, _super);
        function TimerFiredEvent(interval, category, uiThreadId) {
                _super.call(this, interval, category, uiThreadId);
        }
        Object.defineProperty(TimerFiredEvent.prototype, "nameAndContext", {
            get: function () {
                if(typeof this._nameAndContext === "undefined") {
                    var timerFiredEventInterval = this.interval;
                    this._nameAndContext = this.name + this.getThreadContext();
                    if(typeof timerFiredEventInterval.timerType !== "undefined") {
                        this._nameAndContext += " (";
                        this._nameAndContext += timerFiredEventInterval.timerType;
                        this._nameAndContext += ")";
                    }
                }
                return this._nameAndContext;
            },
            enumerable: true,
            configurable: true
        });
        TimerFiredEvent.prototype.getDescription = function () {
            return Plugin.Resources.getString("TimerFiredEventDescription");
        };
        TimerFiredEvent.prototype.getDetails = function (details, isForStartEvent) {
            var result = [];
            if(details) {
                var timerFiredEventDetails = details;
                var timerTypeValueLabel;
                switch(timerFiredEventDetails.TimerType) {
                    case 0: {
                        timerTypeValueLabel = "TimeoutTimerTypeLabel";
                        break;

                    }
                    case 1: {
                        timerTypeValueLabel = "IntervalTimerTypeLabel";
                        break;

                    }
                    case 2: {
                        timerTypeValueLabel = "ImmediateTimerTypeLabel";
                        break;

                    }
                }
                result.push(this.createDetailInfo("TimerType", timerFiredEventDetails.TimerType, "TimerTypeLabel", timerTypeValueLabel));
            }
            return result;
        };
        TimerFiredEvent.prototype.getEventDetailsRequestInformation = function () {
            var eventDetailsRequest = [];
            eventDetailsRequest.push({
                threadId: this.interval.beginThreadId,
                eventTime: this.interval.begin,
                isStartRequest: true
            });
            return eventDetailsRequest;
        };
        return TimerFiredEvent;
    })(Event);
    VisualProfiler.TimerFiredEvent = TimerFiredEvent;    
    var WindowsRuntimeEvent = (function (_super) {
        __extends(WindowsRuntimeEvent, _super);
        function WindowsRuntimeEvent(interval, category, uiThreadId) {
                _super.call(this, interval, category, uiThreadId);
        }
        Object.defineProperty(WindowsRuntimeEvent.prototype, "nameAndContext", {
            get: function () {
                if(typeof this._nameAndContext === "undefined") {
                    this._nameAndContext = this.name + this.getThreadContext();
                    var eventName = this.getEventName();
                    if(eventName) {
                        this._nameAndContext += " (";
                        this._nameAndContext += eventName;
                        this._nameAndContext += ")";
                    }
                }
                return this._nameAndContext;
            },
            enumerable: true,
            configurable: true
        });
        WindowsRuntimeEvent.prototype.getDescription = function () {
            return Plugin.Resources.getString("WindowsRuntimeEventDescription");
        };
        WindowsRuntimeEvent.prototype.getDetails = function (details, isForStartEvent) {
            var result = [];
            result.push(this.createDetailInfo("EventName", this.getEventName(), "EventNameLabel", null));
            return result;
        };
        WindowsRuntimeEvent.prototype.getEventName = function () {
            var winRuntimeEventInterval = this.interval;
            if(typeof winRuntimeEventInterval.eventName !== "undefined") {
                return winRuntimeEventInterval.eventName;
            }
            return null;
        };
        return WindowsRuntimeEvent;
    })(Event);
    VisualProfiler.WindowsRuntimeEvent = WindowsRuntimeEvent;    
    var WindowsRuntimeAsyncCallback = (function (_super) {
        __extends(WindowsRuntimeAsyncCallback, _super);
        function WindowsRuntimeAsyncCallback(interval, category, uiThreadId) {
                _super.call(this, interval, category, uiThreadId);
        }
        WindowsRuntimeAsyncCallback.prototype.getDescription = function () {
            return Plugin.Resources.getString("WindowsRuntimeAsyncCallbackDescription");
        };
        return WindowsRuntimeAsyncCallback;
    })(Event);
    VisualProfiler.WindowsRuntimeAsyncCallback = WindowsRuntimeAsyncCallback;    
    var EventFactory = (function () {
        function EventFactory() {
            this._nameToEventMap = {
            };
            this._nameToEventMap["AlignedBeat"] = AlignedBeatEvent;
            this._nameToEventMap["AnimationFrame"] = AnimationFrameEvent;
            this._nameToEventMap["CssCalculation"] = CssCalculationEvent;
            this._nameToEventMap["CssParsing"] = CssParsingEvent;
            this._nameToEventMap["DomEvent"] = DomEvent;
            this._nameToEventMap["EvaluatingScript"] = EvaluatingScriptEvent;
            this._nameToEventMap["EventHandler"] = EventHandlerEvent;
            this._nameToEventMap["GarbageCollection"] = GarbageCollectionEvent;
            this._nameToEventMap["HtmlParsing"] = HtmlParsingEvent;
            this._nameToEventMap["HtmlSpeculativeDownloading"] = HtmlSpeculativeDownloadingEvent;
            this._nameToEventMap["HttpRequest"] = HttpRequestEvent;
            this._nameToEventMap["ImageDecoded"] = ImageDecodedEvent;
            this._nameToEventMap["Layout"] = LayoutEvent;
            this._nameToEventMap["Paint"] = PaintEvent;
            this._nameToEventMap["RenderLayer"] = RenderLayerEvent;
            this._nameToEventMap["TimerFired"] = TimerFiredEvent;
            this._nameToEventMap["WindowsRuntimeEvent"] = WindowsRuntimeEvent;
            this._nameToEventMap["WindowsRuntimeAsyncCallback"] = WindowsRuntimeAsyncCallback;
        }
        EventFactory.prototype.createEvent = function (interval, uiThreadId) {
            var category = ((EventCategory)[interval.category]);
            var eventType = this._nameToEventMap[interval.name];
            if(eventType) {
                return new eventType(interval, category, uiThreadId);
            } else {
                throw new Error(Plugin.Resources.getErrorString("JSPerf.1040"));
            }
        };
        return EventFactory;
    })();
    VisualProfiler.EventFactory = EventFactory;    
    var EventsTimelineDataSource = (function () {
        function EventsTimelineDataSource(queryResult, uiThreadId, eventsFactory) {
            this._queryResult = queryResult;
            this._count = this._queryResult.getIntervalsCount();
            this._uiThreadId = uiThreadId;
            this._data = [];
            this._dataPrevious = [];
            this._eventsFactory = eventsFactory;
            this._currentIndex = null;
        }
        EventsTimelineDataSource.PrefetchSize = 30;
        Object.defineProperty(EventsTimelineDataSource.prototype, "count", {
            get: function () {
                return this._count;
            },
            enumerable: true,
            configurable: true
        });
        EventsTimelineDataSource.prototype.collapseIntervalBranch = function (index) {
            this._queryResult.collapseIntervalBranch(index);
            this.resetData();
        };
        EventsTimelineDataSource.prototype.expandIntervalBranch = function (index) {
            this._queryResult.expandIntervalBranch(index);
            this.resetData();
        };
        EventsTimelineDataSource.prototype.getNext = function (skip) {
            if(this._currentIndex === null) {
                throw new Error(Plugin.Resources.getErrorString("JSPerf.1057"));
            }
            if(this._currentIndex >= this.count) {
                return null;
            }
            var event = this._data[this._currentIndex];
            if(!event) {
                if(!this.fetchFromPrevious(this._currentIndex, EventsTimelineDataSource.PrefetchSize)) {
                    this.fetchData(this._currentIndex, EventsTimelineDataSource.PrefetchSize);
                }
                event = this._data[this._currentIndex];
            }
            this._currentIndex++;
            if(!isNaN(skip)) {
                this._currentIndex += skip;
            }
            return event;
        };
        EventsTimelineDataSource.prototype.indexOfInterval = function (eventId) {
            return this._queryResult.indexOfInterval(eventId);
        };
        EventsTimelineDataSource.prototype.startAt = function (index) {
            if(this._currentIndex !== null) {
                throw new Error(Plugin.Resources.getErrorString("JSPerf.1058"));
            }
            if(isNaN(index) || index < 0 || index >= this.count) {
                throw new Error(Plugin.Resources.getErrorString("JSPerf.1036"));
            }
            this._currentIndex = index;
            this._data = [];
        };
        EventsTimelineDataSource.prototype.stop = function () {
            this._currentIndex = null;
            this._dataPrevious = this._data;
            this._data = null;
        };
        EventsTimelineDataSource.prototype.fetchData = function (index, max) {
            var fromIndex = Math.max(0, index - max);
            var toIndex = Math.min(this._count, index + max) - 1;
            var intervals = this._queryResult.getIntervals(fromIndex, toIndex);
            var dataIndex = fromIndex;
            for(var i = 0; i < intervals.length; i++ , dataIndex++) {
                if(!this._data[dataIndex]) {
                    var interval = intervals[i];
                    this._data[dataIndex] = this._eventsFactory.createEvent(interval, this._uiThreadId);
                }
            }
        };
        EventsTimelineDataSource.prototype.fetchFromPrevious = function (index, max) {
            if(this._dataPrevious[index]) {
                var fromIndex = Math.max(0, index - max);
                var toIndex = Math.min(this._dataPrevious.length, index + max) - 1;
                for(var i = fromIndex; i <= toIndex; i++) {
                    var item = this._dataPrevious[i];
                    if(item) {
                        this._data[i] = item;
                    }
                }
                return true;
            }
            return false;
        };
        EventsTimelineDataSource.prototype.resetData = function () {
            this._dataPrevious = [];
            this._data = [];
            this._count = this._queryResult.getIntervalsCount();
        };
        return EventsTimelineDataSource;
    })();
    VisualProfiler.EventsTimelineDataSource = EventsTimelineDataSource;    
    var EventsTimelineModel = (function () {
        function EventsTimelineModel(session) {
            this._eventFactory = new EventFactory();
            this._session = session;
        }
        EventsTimelineModel.prototype.getEventDetails = function (threadId, eventTime) {
            return this._session.getEventData(threadId, eventTime);
        };
        EventsTimelineModel.prototype.getEvents = function (timeSpan, sort) {
            var data = [];
            var minDuration = 0;
            var intervalsQuery = this._session.queryEventIntervals(timeSpan.begin.nsec, timeSpan.end.nsec, minDuration, sort);
            var uiThreadId = this._session.queryUIThreadId();
            return new EventsTimelineDataSource(intervalsQuery, uiThreadId, this._eventFactory);
        };
        return EventsTimelineModel;
    })();
    VisualProfiler.EventsTimelineModel = EventsTimelineModel;    
    var EventsTimelineViewModel = (function () {
        function EventsTimelineViewModel(model, globalRuler, markEventModel) {
            this._model = model;
            this._globalRuler = globalRuler;
            this._markEventModel = markEventModel;
            this._globalRuler.addEventListener(VisualProfiler.GlobalRuler.SelectionChangedEventType, this.onRulerSelectionChanged.bind(this));
            this.timeSpan = this._globalRuler.totalRange;
        }
        Object.defineProperty(EventsTimelineViewModel.prototype, "selectedEvent", {
            get: function () {
                return this._selectedEvent;
            },
            set: function (event) {
                if(this._selectedEvent !== event) {
                    this._selectedEvent = event;
                    if(this.selectedEventChanged) {
                        this.selectedEventChanged(this._selectedEvent);
                    }
                    Plugin.VS.Internal.CodeMarkers.fire(VisualProfiler.CodeMarkerValues.perfBrowserTools_VisualProfilerGridRowSelected);
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(EventsTimelineViewModel.prototype, "sort", {
            set: function (sort) {
                if(this._sort !== sort) {
                    this._sort = sort;
                    this._isDataSourceInvalid = true;
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(EventsTimelineViewModel.prototype, "timeSpan", {
            get: function () {
                return this._timeSpan;
            },
            set: function (timeSpan) {
                if((timeSpan === undefined && this._timeSpan !== undefined) || (timeSpan !== undefined && this._timeSpan === undefined) || (timeSpan !== undefined && this._timeSpan !== undefined && !timeSpan.equals(this._timeSpan))) {
                    this._timeSpan = timeSpan;
                    this._isDataSourceInvalid = true;
                    if(this.timeSpanChanged) {
                        this.timeSpanChanged();
                    }
                }
            },
            enumerable: true,
            configurable: true
        });
        EventsTimelineViewModel.prototype.getEventDetails = function (event) {
            var detailsRequests = event.getEventDetailsRequestInformation();
            if(!detailsRequests || detailsRequests.length === 0) {
                return event.getDetails();
            }
            var result = [];
            for(var i = 0; i < detailsRequests.length; i++) {
                var detailRequest = detailsRequests[i];
                var details = this._model.getEventDetails(detailRequest.threadId, detailRequest.eventTime);
                result = result.concat(event.getDetails(details, detailRequest.isStartRequest));
            }
            return result;
        };
        EventsTimelineViewModel.prototype.getEvents = function () {
            if(this._isDataSourceInvalid) {
                this._dataSource = this._model.getEvents(this._timeSpan, this._sort);
                this._isDataSourceInvalid = false;
            }
            return this._dataSource;
        };
        EventsTimelineViewModel.prototype.getMarks = function (category) {
            return this._markEventModel.getMarkEvents(this._globalRuler.totalRange, category);
        };
        EventsTimelineViewModel.prototype.getMarkTooltip = function (mark) {
            return this._markEventModel.getMarkTooltip(mark);
        };
        EventsTimelineViewModel.prototype.getVerticalRulerLinePositions = function (viewWidth) {
            return VisualProfiler.Graph.RulerUtilities.getVerticalLinePositions(this._timeSpan, viewWidth);
        };
        EventsTimelineViewModel.prototype.onRulerSelectionChanged = function (args) {
            this.timeSpan = new VisualProfiler.TimeSpan(this._globalRuler.selection.begin, this._globalRuler.selection.end);
        };
        return EventsTimelineViewModel;
    })();
    VisualProfiler.EventsTimelineViewModel = EventsTimelineViewModel;    
    var EventDataTooltip = (function (_super) {
        __extends(EventDataTooltip, _super);
        function EventDataTooltip(event) {
                _super.call(this, "eventDataTooltip");
            var durationExcluve = this.findElement("durationExc");
            var durationInclusive = this.findElement("durationInc");
            var startTime = this.findElement("startTime");
            durationExcluve.innerText = Plugin.Resources.getString("DurationLabelExclusive", VisualProfiler.FormattingHelpers.getPrettyPrintTime(event.exclusiveDuration));
            durationInclusive.innerText = Plugin.Resources.getString("DurationLabelInclusive", VisualProfiler.FormattingHelpers.getPrettyPrintTime(event.timeSpan.elapsed));
            startTime.innerText = Plugin.Resources.getString("StartTimeLabel", VisualProfiler.FormattingHelpers.getPrettyPrintTime(event.timeSpan.begin));
        }
        return EventDataTooltip;
    })(Common.Controls.TemplateControl);
    VisualProfiler.EventDataTooltip = EventDataTooltip;    
    var EventDataTemplate = (function (_super) {
        __extends(EventDataTemplate, _super);
        function EventDataTemplate() {
            var _this = this;
                _super.call(this, "eventDataTemplate");
            this._bar = this.findElement("bar");
            this._durationText = this.findElement("durationText");
            this._eventDataTemplateNameCell = this.findElement("eventDataTemplateNameCell");
            this._eventData = this.findElement("eventData");
            this._eventName = this.findElement("eventName");
            this._expander = this.findElement("expander");
            this._expander.addEventListener("click", this.onExpansionClicked.bind(this));
            this._bar.addEventListener("mouseover", function () {
                return _this.showBarTooltip.bind(_this);
            });
            this._bar.addEventListener("mouseout", Plugin.VS.Tooltip.dismiss);
            this._eventName.addEventListener("mouseover", this.showEventNameTooltip.bind(this));
            this._eventName.addEventListener("mouseout", Plugin.VS.Tooltip.dismiss);
            this.rootElement.addEventListener("dblclick", this.onExpansionClicked.bind(this));
        }
        EventDataTemplate.IndentationInPixels = 20;
        EventDataTemplate._collapsedCssClass = "itemCollapsed";
        EventDataTemplate._expandedCssClass = "itemExpanded";
        EventDataTemplate.prototype.updateEvent = function (event, parentTimeSpan) {
            if(this._event !== event || !this._parentTimeSpan || !this._parentTimeSpan.equals(parentTimeSpan)) {
                this._event = event;
                this._parentTimeSpan = parentTimeSpan;
                this.updateUi();
            }
        };
        EventDataTemplate.prototype.collapse = function () {
            if(this._event && this._event.hasChildren) {
                if(!this._expander.classList.contains(EventDataTemplate._collapsedCssClass)) {
                    this.onExpansionClicked(null);
                    return true;
                }
            }
            return false;
        };
        EventDataTemplate.prototype.expand = function () {
            if(this._event && this._event.hasChildren) {
                if(!this._expander.classList.contains(EventDataTemplate._expandedCssClass)) {
                    this.onExpansionClicked(null);
                    return true;
                }
            }
            return false;
        };
        EventDataTemplate.prototype.onExpansionClicked = function (e) {
            if(e) {
                e.stopImmediatePropagation();
            }
            if(this.expansionToggledCallback) {
                this.expansionToggledCallback();
            }
        };
        EventDataTemplate.prototype.showBarTooltip = function () {
            if(this._event) {
                var toolTipControl = new EventDataTooltip(this._event);
                var config = {
                    content: toolTipControl.rootElement.innerHTML
                };
                Plugin.VS.Tooltip.show(config);
            }
        };
        EventDataTemplate.prototype.showEventNameTooltip = function (mouseEvent) {
            if(this._event) {
                var eventDiv = mouseEvent.currentTarget;
                if(eventDiv.offsetWidth < eventDiv.scrollWidth) {
                    var config = {
                        content: this._event.nameAndContext
                    };
                    Plugin.VS.Tooltip.show(config);
                }
            }
        };
        EventDataTemplate.prototype.updateUi = function () {
            var event = this._event;
            this._eventDataTemplateNameCell.style.marginLeft = (event.level * EventDataTemplate.IndentationInPixels) + "px";
            EventDataTemplate.setExpanderCss(this._expander, event);
            this._eventName.innerText = event.nameAndContext;
            var left = (event.timeSpan.begin.nsec - this._parentTimeSpan.begin.nsec) / this._parentTimeSpan.elapsed.nsec * 100;
            var width = event.timeSpan.elapsed.nsec / this._parentTimeSpan.elapsed.nsec * 100;
            this._bar.style.marginLeft = left + "%";
            this._bar.style.width = width + "%";
            EventDataTemplate.setBarCss(this._bar, event);
            this._durationText.innerText = VisualProfiler.FormattingHelpers.getPrettyPrintTime(event.timeSpan.elapsed);
            if(!event.exclusiveDuration.equals(event.timeSpan.elapsed)) {
                this._durationText.innerText += " (" + VisualProfiler.FormattingHelpers.getPrettyPrintTime(event.exclusiveDuration) + ")";
            }
        };
        EventDataTemplate.setBarCss = function setBarCss(bar, event) {
            bar.className = "eventBar " + event.getCssClass();
        }
        EventDataTemplate.setExpanderCss = function setExpanderCss(expander, event) {
            if(event.hasChildren) {
                if(!event.isExpanded) {
                    expander.classList.remove(EventDataTemplate._expandedCssClass);
                    expander.classList.add(EventDataTemplate._collapsedCssClass);
                } else {
                    expander.classList.remove(EventDataTemplate._collapsedCssClass);
                    expander.classList.add(EventDataTemplate._expandedCssClass);
                }
            } else {
                expander.classList.remove(EventDataTemplate._expandedCssClass);
                expander.classList.remove(EventDataTemplate._collapsedCssClass);
            }
        }
        return EventDataTemplate;
    })(Common.Controls.TemplateControl);
    VisualProfiler.EventDataTemplate = EventDataTemplate;    
    var EventDetailsView = (function (_super) {
        __extends(EventDetailsView, _super);
        function EventDetailsView(event, details) {
                _super.call(this, "eventDetailsTemplate");
            if(event === null) {
                var eventDetailsHead = this.findElement("eventDetailsHead");
                var description = this.findElement("eventDetailsDescription");
                var separator = this.findElement("detailSeparator");
                eventDetailsHead.classList.add("emptyHeader");
                description.innerText = Plugin.Resources.getString("SelectAnEventDescription");
                separator.style.display = "none";
            } else {
                this._details = details;
                this._event = event;
                this.displayCommonFields();
                this.displayEventSpecificFields();
                var cells = this.findElementsByClassName("eventCell");
                for(var cellIndex = 0; cellIndex < cells.length; cellIndex++) {
                    var cell = cells[cellIndex];
                    (function (value) {
                        cell.addEventListener("mouseover", function (mouseEvent) {
                            return EventDetailsView.showCellTooltip(mouseEvent, value);
                        });
                        cell.addEventListener("mouseout", Plugin.VS.Tooltip.dismiss);
                    })(cell.innerText);
                }
            }
        }
        EventDetailsView.showCellTooltip = function showCellTooltip(mouseEvent, text) {
            var div = mouseEvent.currentTarget;
            if(div.offsetWidth < div.scrollWidth) {
                Plugin.VS.Tooltip.show(text);
            }
        }
        EventDetailsView.prototype.createDiv = function (value, className) {
            var div = document.createElement("div");
            div.innerText = value;
            div.classList.add(className);
            return div;
        };
        EventDetailsView.prototype.displayCommonFields = function () {
            var eventDetailsHead = this.findElement("eventDetailsHead");
            var eventDetailsTitle = this.findElement("eventDetailsTitle");
            var durationLabelExc = this.findElement("durationLabelExc");
            var durationValueExc = this.findElement("durationValueExc");
            var durationLabelInc = this.findElement("durationLabelInc");
            var durationValueInc = this.findElement("durationValueInc");
            var startTimeLabel = this.findElement("startTimeLabel");
            var startTimeValue = this.findElement("startTimeValue");
            var threadContextLabel = this.findElement("threadContextLabel");
            var threadContextValue = this.findElement("threadContextValue");
            var description = this.findElement("eventDetailsDescription");
            eventDetailsHead.classList.add(this._event.getCssClass());
            eventDetailsTitle.innerText = this._event.name;
            durationLabelExc.innerText = Plugin.Resources.getString("DurationLabelExclusive", "");
            durationValueExc.innerText = VisualProfiler.FormattingHelpers.getPrettyPrintTime(this._event.exclusiveDuration);
            durationLabelInc.innerText = Plugin.Resources.getString("DurationLabelInclusive", "");
            durationValueInc.innerText = VisualProfiler.FormattingHelpers.getPrettyPrintTime(this._event.timeSpan.elapsed);
            startTimeLabel.innerText = Plugin.Resources.getString("StartTimeLabel", "");
            startTimeValue.innerText = VisualProfiler.FormattingHelpers.getPrettyPrintTime(this._event.timeSpan.begin);
            threadContextLabel.innerText = Plugin.Resources.getString("ThreadContextLabel", "");
            threadContextValue.innerText = this.getThreadContext();
            description.innerText = this._event.getDescription();
        };
        EventDetailsView.prototype.displayEventSpecificFields = function () {
            if(!this._details) {
                return;
            }
            var additionalDetailsContainer = this.findElement("additionalDetails");
            for(var i = 0; i < this._details.length; i++) {
                var detail = this._details[i];
                var nameDiv = this.createDiv(detail.localizedName + ":", "eventCell");
                var valueDiv = this.createDiv(detail.localizedValue, "eventCell");
                var additionalDetailsLabelValuePair = this.createDiv("", "eventRow");
                additionalDetailsLabelValuePair.appendChild(nameDiv);
                additionalDetailsLabelValuePair.appendChild(valueDiv);
                additionalDetailsContainer.appendChild(additionalDetailsLabelValuePair);
            }
        };
        EventDetailsView.prototype.getThreadContext = function () {
            var threadId = this._event.contextThreadId;
            if(threadId !== null) {
                return threadId.toString();
            }
            return Plugin.Resources.getString("UIThreadContext");
        };
        return EventDetailsView;
    })(Common.Controls.TemplateControl);
    VisualProfiler.EventDetailsView = EventDetailsView;    
    var EventsTimelineListControl = (function (_super) {
        __extends(EventsTimelineListControl, _super);
        function EventsTimelineListControl(rootElement) {
            var _this = this;
                _super.call(this, rootElement);
            this._selectedItemVisibleIndex = -1;
            this.rootElement.tabIndex = 0;
            this.rootElement.addEventListener("keydown", this.onKeyDown.bind(this));
            this._panel = new VisualProfiler.VirtualizingStackPanel(this.rootElement);
            this._panel.templateBinder = this;
            this._itemContainerGenerator = new VisualProfiler.ItemContainerGenerator();
            this._panel.itemContainerGenerator = this._itemContainerGenerator;
            this._columnsCssRule = this.getColumnsCssRule();
            window.addEventListener("resize", function () {
                return _this._columnsCssRule = _this.getColumnsCssRule();
            });
            this._divider = new VisualProfiler.Divider(this._panel.rootElement, this.eventNameColumnWidth);
            this._divider.onMoved = this.onResizeColumns.bind(this);
            this._verticalRulerLineElementsFactory = VisualProfiler.ElementRecyclerFactory.forDivWithClass(this.rootElement, "verticalRulerLine");
            this.rootElement.setAttribute("aria-label", Plugin.Resources.getString("EventsTimelineAriaLabel"));
            this.rootElement.onresize = this.invalidateSizeCache.bind(this);
            this.invalidateSizeCache();
        }
        Object.defineProperty(EventsTimelineListControl.prototype, "dataColumnLeft", {
            get: function () {
                var columns = this._columnsCssRule.style.msGridColumns.split(' ');
                return parseInt(columns[0]) + parseInt(columns[1]);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(EventsTimelineListControl.prototype, "dataColumnWidth", {
            get: function () {
                if(this._dataColumnWidth === null) {
                    var panelScrollBarWidth = this._panel.rootElement.offsetWidth - this._panel.rootElement.clientWidth;
                    this._dataColumnWidth = this.rootElement.offsetWidth - this.dataColumnLeft - panelScrollBarWidth;
                }
                return this._dataColumnWidth;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(EventsTimelineListControl.prototype, "dataSource", {
            get: function () {
                return this._dataSource;
            },
            set: function (value) {
                if(this._dataSource !== value) {
                    var selectionViewportOffset = 0;
                    if(this._selectedItem && this._itemContainerGenerator) {
                        var selectedItemContainer = this._itemContainerGenerator.getItemContainerFromItemId(this._selectedItem.id);
                        if(selectedItemContainer) {
                            selectionViewportOffset = this._panel.getScrollViewportOffset(selectedItemContainer);
                        }
                    }
                    this._dataSource = value;
                    if(this._selectedItem) {
                        this._selectedItemVisibleIndex = this.getVisibleIndexOfItem(this._selectedItem);
                        if(this._selectedItemVisibleIndex < 0) {
                            this.selectedItem = null;
                            this._panel.scrollToOffset(0, true);
                        } else {
                            this._panel.scrollToIndex(this._selectedItemVisibleIndex, -selectionViewportOffset, true);
                        }
                    } else {
                        this._panel.scrollToOffset(0, true);
                    }
                    this._itemContainerGenerator.setDataSource(value);
                    this._panel.invalidate();
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(EventsTimelineListControl.prototype, "eventNameColumnWidth", {
            get: function () {
                var columns = this._columnsCssRule.style.msGridColumns.split(' ');
                return parseInt(columns[0]);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(EventsTimelineListControl.prototype, "itemContainerGenerator", {
            get: function () {
                return this._itemContainerGenerator;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(EventsTimelineListControl.prototype, "offsetLeft", {
            get: function () {
                if(this._offsetLeft === null) {
                    this._offsetLeft = this.rootElement.offsetLeft;
                }
                return this._offsetLeft;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(EventsTimelineListControl.prototype, "offsetTop", {
            get: function () {
                if(this._offsetTop === null) {
                    this._offsetTop = this.rootElement.offsetTop;
                }
                return this._offsetTop;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(EventsTimelineListControl.prototype, "selectedItem", {
            get: function () {
                return this._selectedItem;
            },
            set: function (value) {
                if(this._selectedItem !== value || (this._selectedItem && value && this._selectedItem.id !== value.id)) {
                    var itemContainer = this.getSelectedItemContainer();
                    if(itemContainer) {
                        itemContainer.isSelected = false;
                    }
                    this._selectedItem = value;
                    if(this._selectedItem) {
                        this._selectedItemVisibleIndex = this.getVisibleIndexOfItem(this._selectedItem);
                    } else {
                        this._selectedItemVisibleIndex = -1;
                    }
                    var itemContainer = this.getSelectedItemContainer(true);
                    if(itemContainer) {
                        this.setItemContainerAreaLabel(itemContainer);
                        itemContainer.focus();
                    }
                    if(this._selectedItemVisibleIndex >= 0) {
                        this._panel.ensureVisible(this._selectedItemVisibleIndex);
                    }
                    if(this.selectedItemChanged) {
                        this.selectedItemChanged(this._selectedItem);
                    }
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(EventsTimelineListControl.prototype, "timeSpan", {
            set: function (timeSpan) {
                this._timeSpan = timeSpan;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(EventsTimelineListControl.prototype, "viewModel", {
            set: function (viewModel) {
                this._viewModel = viewModel;
            },
            enumerable: true,
            configurable: true
        });
        EventsTimelineListControl.prototype.bind = function (itemContainer, itemIndex) {
            var event = itemContainer.item;
            if(!itemContainer.template) {
                itemContainer.template = new EventDataTemplate();
                itemContainer.rootElement.tabIndex = -1;
                itemContainer.rootElement.appendChild(itemContainer.template.rootElement);
            }
            (itemContainer.template).updateEvent(event, this._timeSpan);
            if(event.hasChildren) {
                (itemContainer.template).expansionToggledCallback = this.onExpansionToggled.bind(this, itemContainer, itemIndex);
            }
            itemContainer.clicked = this.onItemSelected.bind(this, itemContainer);
            itemContainer.isSelected = this._selectedItem && itemContainer.id === this._selectedItem.id;
        };
        EventsTimelineListControl.prototype.invalidateSizeCache = function () {
            this._dataColumnWidth = null;
            this._offsetLeft = null;
            this._offsetTop = null;
            this._panel.invalidateSizeCache();
        };
        EventsTimelineListControl.prototype.render = function () {
            this.invalidate();
        };
        EventsTimelineListControl.prototype.renderVerticalRulerLines = function () {
            var positions = this._viewModel.getVerticalRulerLinePositions(this.dataColumnWidth);
            this._verticalRulerLineElementsFactory.start();
            for(var i = 0; i < positions.length; ++i) {
                var line = this._verticalRulerLineElementsFactory.getNext();
                var x = this.dataColumnWidth * positions[i] / 100 + this.dataColumnLeft + this.offsetLeft;
                this.positionVerticalRulerLine(line, x, this.offsetTop, this._panel.viewportHeight);
            }
            this._verticalRulerLineElementsFactory.stop();
        };
        EventsTimelineListControl.prototype.unbind = function (itemContainer) {
            var template = itemContainer.template;
            if(template) {
                template.expansionToggledCallback = null;
            }
            itemContainer.clicked = null;
            itemContainer.rootElement.removeAttribute("aria-label");
        };
        EventsTimelineListControl.prototype.positionVerticalRulerLine = function (line, x, y, height) {
            line.style.left = x + "px";
            line.style.height = height + "px";
            line.style.top = y + "px";
        };
        EventsTimelineListControl.prototype.getColumnsCssRule = function () {
            return EventsTimelineView.getCssRule("VisualProfiler.css", ".eventDataTemplate");
        };
        EventsTimelineListControl.prototype.getItemContainerFromItem = function (item, scrollIfNeeded) {
            var itemContainer = this._itemContainerGenerator.getItemContainerFromItemId(item.id);
            if(!itemContainer && scrollIfNeeded) {
                this.scrollToItem(item);
                itemContainer = this._itemContainerGenerator.getItemContainerFromItemId(item.id);
            }
            return itemContainer;
        };
        EventsTimelineListControl.prototype.getSelectedItemContainer = function (scrollIfNeeded) {
            if(this.selectedItem) {
                return this.getItemContainerFromItem(this.selectedItem, scrollIfNeeded);
            }
            return null;
        };
        EventsTimelineListControl.prototype.getVisibleIndexOfItem = function (item) {
            return this._dataSource.indexOfInterval(item.id);
        };
        EventsTimelineListControl.prototype.invalidate = function () {
            this._panel.invalidate();
            this._panel.render();
            this.updateDividerHeight();
        };
        EventsTimelineListControl.prototype.onKeyDown = function (event) {
            var handled = true;
            switch(event.keyCode) {
                case KeyCodes.ARROW_UP: {
                    if(this._selectedItemVisibleIndex < 0) {
                        this.setSelectedItemVisibleIndex(0);
                    } else {
                        this.selectPreviousItem();
                    }
                    break;

                }
                case KeyCodes.ARROW_DOWN: {
                    if(this._selectedItemVisibleIndex < 0) {
                        this.setSelectedItemVisibleIndex(0);
                    } else {
                        this.selectNextItem();
                    }
                    break;

                }
                case KeyCodes.PAGE_UP: {
                    this.selectPageUp();
                    break;

                }
                case KeyCodes.PAGE_DOWN: {
                    this.selectPageDown();
                    break;

                }
                case KeyCodes.HOME: {
                    this.selectHome();
                    break;

                }
                case KeyCodes.END: {
                    this.selectEnd();
                    break;

                }
                case KeyCodes.ARROW_RIGHT: {
                    var selectedItemContainer = this.getSelectedItemContainer();
                    if(selectedItemContainer) {
                        if(!(selectedItemContainer.template).expand() && (selectedItemContainer.item).hasChildren) {
                            this.selectNextItem();
                        }
                    }
                    break;

                }
                case KeyCodes.ARROW_LEFT: {
                    var selectedItemContainer = this.getSelectedItemContainer();
                    if(selectedItemContainer) {
                        if(!(selectedItemContainer.template).collapse() && (selectedItemContainer.item).level > 0) {
                            this.selectPreviousItem();
                        }
                    }
                    break;

                }
                case KeyCodes.PLUS: {
                    var selectedItemContainer = this.getSelectedItemContainer();
                    if(selectedItemContainer) {
                        (selectedItemContainer.template).expand();
                    }
                    break;

                }
                case KeyCodes.MINUS: {
                    var selectedItemContainer = this.getSelectedItemContainer();
                    if(selectedItemContainer) {
                        (selectedItemContainer.template).collapse();
                    }
                    break;

                }
                default: {
                    handled = false;

                }
            }
            if(handled) {
                event.preventDefault();
                event.stopPropagation();
            }
        };
        EventsTimelineListControl.prototype.onItemSelected = function (itemContainer) {
            this.selectedItem = itemContainer.item;
            itemContainer.focus();
        };
        EventsTimelineListControl.prototype.onResizeColumns = function (offsetX) {
            this._dataColumnWidth = null;
            this.updateColumnWidth(offsetX);
            this.renderVerticalRulerLines();
            if(this.dataColumnWidthChanged) {
                this.dataColumnWidthChanged();
            }
        };
        EventsTimelineListControl.prototype.onExpansionToggled = function (itemContainer, itemIndex) {
            var event = itemContainer.item;
            if(event.isExpanded) {
                this._dataSource.collapseIntervalBranch(itemIndex);
            } else {
                this._dataSource.expandIntervalBranch(itemIndex);
            }
            this.selectedItem = event;
            this.invalidate();
            var selectedItemContainer = this.getSelectedItemContainer();
            if(selectedItemContainer) {
                selectedItemContainer.focus();
            }
        };
        EventsTimelineListControl.prototype.scrollToItem = function (item) {
            var visibleIndex = this.getVisibleIndexOfItem(item);
            if(visibleIndex >= 0) {
                this._panel.ensureVisible(visibleIndex);
            }
        };
        EventsTimelineListControl.prototype.selectEnd = function () {
            if(this._selectedItemVisibleIndex < 0) {
                return;
            }
            this.setSelectedItemVisibleIndex(this._itemContainerGenerator.count - 1);
        };
        EventsTimelineListControl.prototype.selectHome = function () {
            if(this._selectedItemVisibleIndex < 0) {
                return;
            }
            this.setSelectedItemVisibleIndex(0);
        };
        EventsTimelineListControl.prototype.selectPreviousItem = function () {
            if(this._selectedItemVisibleIndex < 0) {
                return;
            }
            this.setSelectedItemVisibleIndex(this._selectedItemVisibleIndex - 1);
        };
        EventsTimelineListControl.prototype.selectPageDown = function () {
            if(this._selectedItemVisibleIndex < 0) {
                return;
            }
            this.setSelectedItemVisibleIndex(this._selectedItemVisibleIndex + this._panel.viewportItemsCount);
        };
        EventsTimelineListControl.prototype.selectPageUp = function () {
            if(this._selectedItemVisibleIndex < 0) {
                return;
            }
            this.setSelectedItemVisibleIndex(this._selectedItemVisibleIndex - this._panel.viewportItemsCount);
        };
        EventsTimelineListControl.prototype.selectNextItem = function () {
            if(this._selectedItemVisibleIndex < 0) {
                return;
            }
            this.setSelectedItemVisibleIndex(this._selectedItemVisibleIndex + 1);
        };
        EventsTimelineListControl.prototype.setItemContainerAreaLabel = function (itemContainer) {
            if(itemContainer) {
                var event = itemContainer.item;
                if(event) {
                    var ariaLabel = event.name;
                    ariaLabel += " , " + Plugin.Resources.getString("StartTimeLabel", VisualProfiler.FormattingHelpers.getPrettyPrintTime(event.timeSpan.begin));
                    ariaLabel += " , " + Plugin.Resources.getString("DurationLabelInclusive", VisualProfiler.FormattingHelpers.getPrettyPrintTime(event.timeSpan.elapsed));
                    if(!event.timeSpan.elapsed.equals(event.exclusiveDuration)) {
                        ariaLabel += " , " + Plugin.Resources.getString("DurationLabelExclusive", VisualProfiler.FormattingHelpers.getPrettyPrintTime(event.exclusiveDuration));
                    }
                    ariaLabel += " , " + Plugin.Resources.getString("ThreadContextLabel", event.contextThreadId || Plugin.Resources.getString("UIThreadContext"));
                    var additionalInfo = this._viewModel.getEventDetails(event);
                    for(var i = 0; i < additionalInfo.length; i++) {
                        ariaLabel += " , " + additionalInfo[i].localizedName + ": " + additionalInfo[i].localizedValue;
                    }
                    itemContainer.rootElement.setAttribute("aria-label", ariaLabel);
                } else {
                    itemContainer.rootElement.removeAttribute("aria-label");
                }
            }
        };
        EventsTimelineListControl.prototype.setSelectedItemVisibleIndex = function (newVisibleIndex) {
            var itemContainer = null;
            var totalVisibleCount = this._itemContainerGenerator.count;
            if(newVisibleIndex < 0) {
                newVisibleIndex = 0;
            }
            if(newVisibleIndex >= totalVisibleCount) {
                newVisibleIndex = totalVisibleCount - 1;
            }
            if(this._selectedItemVisibleIndex >= 0 && this._selectedItemVisibleIndex === newVisibleIndex) {
                itemContainer = this.getSelectedItemContainer();
            } else {
                if(newVisibleIndex >= 0 && newVisibleIndex < totalVisibleCount) {
                    this._itemContainerGenerator.startAt(newVisibleIndex);
                    itemContainer = this._itemContainerGenerator.getNext();
                    this._itemContainerGenerator.stop();
                    if(itemContainer) {
                        var item = itemContainer.item;
                        if(!itemContainer.rootElement.parentElement) {
                            this._itemContainerGenerator.recycle(newVisibleIndex);
                        }
                        this.selectedItem = item;
                    }
                }
            }
            return itemContainer;
        };
        EventsTimelineListControl.prototype.updateColumnWidth = function (offsetX) {
            if(offsetX === null || typeof offsetX === "undefined") {
                offsetX = this._divider.offsetX;
            }
            var columns = this._columnsCssRule.style.msGridColumns.split(' ');
            columns[0] = offsetX + "px";
            this._columnsCssRule.style.msGridColumns = columns.join(' ');
        };
        EventsTimelineListControl.prototype.updateDividerHeight = function () {
            var height = Math.max(this._panel.virtualHeight, this._panel.actualHeight);
            this._divider.height = height;
        };
        return EventsTimelineListControl;
    })(Common.Controls.Control);
    VisualProfiler.EventsTimelineListControl = EventsTimelineListControl;    
    var EventsTimelineView = (function (_super) {
        __extends(EventsTimelineView, _super);
        function EventsTimelineView(parentContainerId) {
                _super.call(this, "timelineViewTemplate");
            this._parentContainer = document.getElementById(parentContainerId);
            if(!this._parentContainer) {
                throw new Error(Plugin.Resources.getErrorString("JSPerf.1034"));
            }
            this._timelineDetailsPaneContainer = this.findElement("timelineDetailsPaneContainer");
            var timelineLabel = this.findElement("timelineLabel");
            var timelineSortLabel = this.findElement("timelineSortLabel");
            this._timelineSortSelector = this.findElement("timelineSortSelector");
            var timelineSortDuration = this.findElement("timelineSortDuration");
            var timelineSortStartTime = this.findElement("timelineSortStartTime");
            var timelineView = this.findElement("timelineView");
            timelineLabel.innerText = Plugin.Resources.getString("TimelineLabel");
            timelineSortLabel.innerText = Plugin.Resources.getString("TimelineSortLabel");
            this._timelineSortSelector.addEventListener("mouseover", function () {
                return EventsTimelineView.showTooltip("TimelineSortTooltip");
            });
            this._timelineSortSelector.addEventListener("mouseout", Plugin.VS.Tooltip.dismiss);
            this._timelineSortSelector.addEventListener("change", this.onSortChanged.bind(this));
            timelineSortDuration.innerText = Plugin.Resources.getString("TimelineSortDuration");
            timelineSortStartTime.innerText = Plugin.Resources.getString("TimelineSortStartTime");
            this._listControl = new EventsTimelineListControl(timelineView);
            this._listControl.dataColumnWidthChanged = this.onListControlDataColumnWidthChanged.bind(this);
            this._parentContainer.appendChild(this.rootElement);
            this.registerResizeEvent();
            this._eventHeaderDivider = this.findElement("timelineEventHeaderDivider");
            this._eventHeaderDivider.style.left = this._listControl.eventNameColumnWidth + "px";
            this._eventHeaderLabel = this.findElement("timelineEventHeaderLabel");
            this._eventHeaderLabel.innerText = Plugin.Resources.getString("EventHeaderLabel");
            this._eventHeaderLabel.style.width = this._listControl.eventNameColumnWidth + "px";
            this._rulerContainer = this.findElement("timelineRuler");
        }
        Object.defineProperty(EventsTimelineView.prototype, "viewModel", {
            set: function (viewModel) {
                this.unregisterViewModelEvents();
                this._viewModel = viewModel;
                this.createRuler();
                this.updateDetailsPane(null);
                this.registerViewModelEvents();
            },
            enumerable: true,
            configurable: true
        });
        EventsTimelineView.prototype.render = function () {
            if(this._viewModel) {
                try  {
                    this.unregisterResizeEvent();
                    this._viewModel.sort = parseInt(this._timelineSortSelector.value);
                    var dataSource = this._viewModel.getEvents();
                    var timeSpan = this._viewModel.timeSpan;
                    this._listControl.dataSource = dataSource;
                    this._listControl.timeSpan = timeSpan;
                    this._listControl.viewModel = this._viewModel;
                    this._listControl.selectedItemChanged = this.onSelectedEventChanged.bind(this);
                    this._listControl.render();
                    this.setRulerRect();
                    this._rulerScale.timeRange = timeSpan;
                    this._rulerScale.render();
                    this._listControl.renderVerticalRulerLines();
                }finally {
                    this.registerResizeEvent();
                }
            }
        };
        EventsTimelineView.prototype.createRuler = function () {
            var _this = this;
            var lifecycleData = [];
            var userMarkData = [];
            if(this._rulerScale) {
                this._rulerScale.deinitialize();
            }
            var lifecycleMarks = this._viewModel.getMarks(0);
            for(var markIndex = 0; markIndex < lifecycleMarks.length; markIndex++) {
                (function (mark) {
                    var markData = new VisualProfiler.Graph.MarkData(VisualProfiler.TimeStamp.fromNanoseconds(mark.time), function () {
                        return _this._viewModel.getMarkTooltip(mark);
                    });
                    lifecycleData.push(markData);
                })(lifecycleMarks[markIndex]);
            }
            var userMarks = this._viewModel.getMarks(1);
            for(var markIndex = 0; markIndex < userMarks.length; markIndex++) {
                (function (mark) {
                    var markData = new VisualProfiler.Graph.MarkData(VisualProfiler.TimeStamp.fromNanoseconds(mark.time), function () {
                        return _this._viewModel.getMarkTooltip(mark);
                    });
                    userMarkData.push(markData);
                })(userMarks[markIndex]);
            }
            this._rulerScale = new VisualProfiler.Graph.RulerScale({
                containerId: this._rulerContainer.id,
                timeRange: new VisualProfiler.TimeSpan(),
                series: [
                    {
                        id: "LifecycleMark",
                        label: Plugin.Resources.getString("RulerLifecycleMarkLabel"),
                        data: lifecycleData,
                        type: VisualProfiler.Graph.MarkType.LifeCycleEvent
                    }, 
                    {
                        id: "UserMark",
                        label: Plugin.Resources.getString("RulerUserMarkLabel"),
                        data: userMarkData,
                        type: VisualProfiler.Graph.MarkType.UserMark
                    }
                ]
            });
        };
        EventsTimelineView.prototype.onSelectedEventChanged = function (event) {
            this._viewModel.selectedEvent = event;
        };
        EventsTimelineView.prototype.onListControlDataColumnWidthChanged = function () {
            this._eventHeaderDivider.style.left = this._listControl.eventNameColumnWidth + "px";
            this._eventHeaderLabel.style.width = this._listControl.eventNameColumnWidth + "px";
            this.setRulerRect();
            this._rulerScale.render();
        };
        EventsTimelineView.prototype.onSortChanged = function (e) {
            Plugin.VS.Internal.CodeMarkers.fire(VisualProfiler.CodeMarkerValues.perfBrowserTools_VisualProfilerSortInvokedOnGrid);
            this.render();
            Plugin.VS.Internal.CodeMarkers.fire(VisualProfiler.CodeMarkerValues.perfBrowserTools_VisualProfilerSortFinishedOnGrid);
        };
        EventsTimelineView.prototype.onTimeSpanChanged = function () {
            this.render();
            Plugin.VS.Internal.CodeMarkers.fire(VisualProfiler.CodeMarkerValues.perfBrowserTools_VisualProfilerGridUpdatedForTimeSelection);
        };
        EventsTimelineView.prototype.onViewModelSelectionChanged = function (event) {
            this._listControl.selectedItem = event;
            this.updateDetailsPane(event);
        };
        EventsTimelineView.prototype.registerResizeEvent = function () {
            var _this = this;
            this._parentContainer.onresize = function () {
                _this._listControl.invalidateSizeCache();
                _this.render();
            };
        };
        EventsTimelineView.prototype.registerViewModelEvents = function () {
            if(this._viewModel) {
                this._viewModel.timeSpanChanged = this.onTimeSpanChanged.bind(this);
                this._viewModel.selectedEventChanged = this.onViewModelSelectionChanged.bind(this);
            }
        };
        EventsTimelineView.prototype.setRulerRect = function () {
            this._rulerContainer.style.marginLeft = this._listControl.dataColumnLeft + "px";
            this._rulerContainer.style.width = this._listControl.dataColumnWidth + "px";
        };
        EventsTimelineView.prototype.updateDetailsPane = function (event) {
            var detailsView;
            if(event === null) {
                detailsView = new EventDetailsView(null, null);
            } else {
                var details = this._viewModel.getEventDetails(event);
                detailsView = new EventDetailsView(event, details);
            }
            this._timelineDetailsPaneContainer.innerHTML = "";
            this._timelineDetailsPaneContainer.appendChild(detailsView.rootElement);
            Plugin.VS.Internal.CodeMarkers.fire(VisualProfiler.CodeMarkerValues.perfBrowserTools_VisualProfilerDetailsPaneLoaded);
        };
        EventsTimelineView.prototype.unregisterResizeEvent = function () {
            this._parentContainer.onresize = null;
        };
        EventsTimelineView.prototype.unregisterViewModelEvents = function () {
            if(this._viewModel) {
                this._viewModel.timeSpanChanged = null;
                this._viewModel.selectedEventChanged = null;
            }
        };
        EventsTimelineView.getCssRule = function getCssRule(styleSheetName, selectorName) {
            var styleSheet = document.styleSheets[styleSheetName];
            if(styleSheet) {
                for(var i = 0; i < styleSheet.rules.length; ++i) {
                    var rule = styleSheet.rules[i];
                    if(rule && rule.selectorText === selectorName) {
                        return rule;
                    }
                }
            }
            return null;
        }
        EventsTimelineView.showTooltip = function showTooltip(resourceId) {
            var config = {
                content: Plugin.Resources.getString(resourceId)
            };
            Plugin.VS.Tooltip.show(config);
        }
        return EventsTimelineView;
    })(Common.Controls.TemplateControl);
    VisualProfiler.EventsTimelineView = EventsTimelineView;    
})(VisualProfiler || (VisualProfiler = {}));
//@ sourceMappingURL=EventsTimelineView.js.map

// SIG // Begin signature block
// SIG // MIIaswYJKoZIhvcNAQcCoIIapDCCGqACAQExCzAJBgUr
// SIG // DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
// SIG // gjcCAR4wJAIBAQQQEODJBs441BGiowAQS9NQkAIBAAIB
// SIG // AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFH7WptR6PacI
// SIG // funzCCRA4Ff85KCMoIIVgjCCBMMwggOroAMCAQICEzMA
// SIG // AAArOTJIwbLJSPMAAAAAACswDQYJKoZIhvcNAQEFBQAw
// SIG // dzELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0
// SIG // b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1p
// SIG // Y3Jvc29mdCBDb3Jwb3JhdGlvbjEhMB8GA1UEAxMYTWlj
// SIG // cm9zb2Z0IFRpbWUtU3RhbXAgUENBMB4XDTEyMDkwNDIx
// SIG // MTIzNFoXDTEzMTIwNDIxMTIzNFowgbMxCzAJBgNVBAYT
// SIG // AlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQH
// SIG // EwdSZWRtb25kMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29y
// SIG // cG9yYXRpb24xDTALBgNVBAsTBE1PUFIxJzAlBgNVBAsT
// SIG // Hm5DaXBoZXIgRFNFIEVTTjpDMEY0LTMwODYtREVGODEl
// SIG // MCMGA1UEAxMcTWljcm9zb2Z0IFRpbWUtU3RhbXAgU2Vy
// SIG // dmljZTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoC
// SIG // ggEBAKa2MA4DZa5QWoZrhZ9IoR7JwO5eSQeF4HCWfL65
// SIG // X2JfBibTizm7GCKlLpKt2EuIOhqvm4OuyF45jMIyexZ4
// SIG // 7Tc4OvFi+2iCAmjs67tAirH+oSw2YmBwOWBiDvvGGDhv
// SIG // sJLWQA2Apg14izZrhoomFxj/sOtNurspE+ZcSI5wRjYm
// SIG // /jQ1qzTh99rYXOqZfTG3TR9X63zWlQ1mDB4OMhc+LNWA
// SIG // oc7r95iRAtzBX/04gPg5f11kyjdcO1FbXYVfzh4c+zS+
// SIG // X+UoVXBUnLjsfABVRlsomChWTOHxugkZloFIKjDI9zMg
// SIG // bOdpw7PUw07PMB431JhS1KkjRbKuXEFJT7RiaJMCAwEA
// SIG // AaOCAQkwggEFMB0GA1UdDgQWBBSlGDNTP5VgoUMW747G
// SIG // r9Irup5Y0DAfBgNVHSMEGDAWgBQjNPjZUkZwCu1A+3b7
// SIG // syuwwzWzDzBUBgNVHR8ETTBLMEmgR6BFhkNodHRwOi8v
// SIG // Y3JsLm1pY3Jvc29mdC5jb20vcGtpL2NybC9wcm9kdWN0
// SIG // cy9NaWNyb3NvZnRUaW1lU3RhbXBQQ0EuY3JsMFgGCCsG
// SIG // AQUFBwEBBEwwSjBIBggrBgEFBQcwAoY8aHR0cDovL3d3
// SIG // dy5taWNyb3NvZnQuY29tL3BraS9jZXJ0cy9NaWNyb3Nv
// SIG // ZnRUaW1lU3RhbXBQQ0EuY3J0MBMGA1UdJQQMMAoGCCsG
// SIG // AQUFBwMIMA0GCSqGSIb3DQEBBQUAA4IBAQB+zLB75S++
// SIG // 51a1z3PbqlLRFjnGtM361/4eZbXnSPObRogFZmomhl7+
// SIG // h1jcxmOOOID0CEZ8K3OxDr9BqsvHqpSkN/BkOeHF1fnO
// SIG // B86r5CXwaa7URuL+ZjI815fFMiH67holoF4MQiwRMzqC
// SIG // g/3tHbO+zpGkkSVxuatysJ6v5M8AYolwqbhKUIzuLyJk
// SIG // pajmTWuVLBx57KejMdqQYJCkbv6TAg0/LCQNxmomgVGD
// SIG // ShC7dWNEqmkIxgPr4s8L7VY67O9ypwoM9ADTIrivInKz
// SIG // 58ScCyiggMrj4dc5ZjDnRhcY5/qC+lkLeryoDf4c/wOL
// SIG // Y7JNEgIjTy2zhYQ74qFH6M8VMIIE7DCCA9SgAwIBAgIT
// SIG // MwAAALARrwqL0Duf3QABAAAAsDANBgkqhkiG9w0BAQUF
// SIG // ADB5MQswCQYDVQQGEwJVUzETMBEGA1UECBMKV2FzaGlu
// SIG // Z3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UEChMV
// SIG // TWljcm9zb2Z0IENvcnBvcmF0aW9uMSMwIQYDVQQDExpN
// SIG // aWNyb3NvZnQgQ29kZSBTaWduaW5nIFBDQTAeFw0xMzAx
// SIG // MjQyMjMzMzlaFw0xNDA0MjQyMjMzMzlaMIGDMQswCQYD
// SIG // VQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4G
// SIG // A1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0
// SIG // IENvcnBvcmF0aW9uMQ0wCwYDVQQLEwRNT1BSMR4wHAYD
// SIG // VQQDExVNaWNyb3NvZnQgQ29ycG9yYXRpb24wggEiMA0G
// SIG // CSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDor1yiIA34
// SIG // KHy8BXt/re7rdqwoUz8620B9s44z5lc/pVEVNFSlz7SL
// SIG // qT+oN+EtUO01Fk7vTXrbE3aIsCzwWVyp6+HXKXXkG4Un
// SIG // m/P4LZ5BNisLQPu+O7q5XHWTFlJLyjPFN7Dz636o9UEV
// SIG // XAhlHSE38Cy6IgsQsRCddyKFhHxPuRuQsPWj/ov0DJpO
// SIG // oPXJCiHiquMBNkf9L4JqgQP1qTXclFed+0vUDoLbOI8S
// SIG // /uPWenSIZOFixCUuKq6dGB8OHrbCryS0DlC83hyTXEmm
// SIG // ebW22875cHsoAYS4KinPv6kFBeHgD3FN/a1cI4Mp68fF
// SIG // SsjoJ4TTfsZDC5UABbFPZXHFAgMBAAGjggFgMIIBXDAT
// SIG // BgNVHSUEDDAKBggrBgEFBQcDAzAdBgNVHQ4EFgQUWXGm
// SIG // WjNN2pgHgP+EHr6H+XIyQfIwUQYDVR0RBEowSKRGMEQx
// SIG // DTALBgNVBAsTBE1PUFIxMzAxBgNVBAUTKjMxNTk1KzRm
// SIG // YWYwYjcxLWFkMzctNGFhMy1hNjcxLTc2YmMwNTIzNDRh
// SIG // ZDAfBgNVHSMEGDAWgBTLEejK0rQWWAHJNy4zFha5TJoK
// SIG // HzBWBgNVHR8ETzBNMEugSaBHhkVodHRwOi8vY3JsLm1p
// SIG // Y3Jvc29mdC5jb20vcGtpL2NybC9wcm9kdWN0cy9NaWND
// SIG // b2RTaWdQQ0FfMDgtMzEtMjAxMC5jcmwwWgYIKwYBBQUH
// SIG // AQEETjBMMEoGCCsGAQUFBzAChj5odHRwOi8vd3d3Lm1p
// SIG // Y3Jvc29mdC5jb20vcGtpL2NlcnRzL01pY0NvZFNpZ1BD
// SIG // QV8wOC0zMS0yMDEwLmNydDANBgkqhkiG9w0BAQUFAAOC
// SIG // AQEAMdduKhJXM4HVncbr+TrURE0Inu5e32pbt3nPApy8
// SIG // dmiekKGcC8N/oozxTbqVOfsN4OGb9F0kDxuNiBU6fNut
// SIG // zrPJbLo5LEV9JBFUJjANDf9H6gMH5eRmXSx7nR2pEPoc
// SIG // sHTyT2lrnqkkhNrtlqDfc6TvahqsS2Ke8XzAFH9IzU2y
// SIG // RPnwPJNtQtjofOYXoJtoaAko+QKX7xEDumdSrcHps3Om
// SIG // 0mPNSuI+5PNO/f+h4LsCEztdIN5VP6OukEAxOHUoXgSp
// SIG // Rm3m9Xp5QL0fzehF1a7iXT71dcfmZmNgzNWahIeNJDD3
// SIG // 7zTQYx2xQmdKDku/Og7vtpU6pzjkJZIIpohmgjCCBbww
// SIG // ggOkoAMCAQICCmEzJhoAAAAAADEwDQYJKoZIhvcNAQEF
// SIG // BQAwXzETMBEGCgmSJomT8ixkARkWA2NvbTEZMBcGCgmS
// SIG // JomT8ixkARkWCW1pY3Jvc29mdDEtMCsGA1UEAxMkTWlj
// SIG // cm9zb2Z0IFJvb3QgQ2VydGlmaWNhdGUgQXV0aG9yaXR5
// SIG // MB4XDTEwMDgzMTIyMTkzMloXDTIwMDgzMTIyMjkzMlow
// SIG // eTELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0
// SIG // b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1p
// SIG // Y3Jvc29mdCBDb3Jwb3JhdGlvbjEjMCEGA1UEAxMaTWlj
// SIG // cm9zb2Z0IENvZGUgU2lnbmluZyBQQ0EwggEiMA0GCSqG
// SIG // SIb3DQEBAQUAA4IBDwAwggEKAoIBAQCycllcGTBkvx2a
// SIG // YCAgQpl2U2w+G9ZvzMvx6mv+lxYQ4N86dIMaty+gMuz/
// SIG // 3sJCTiPVcgDbNVcKicquIEn08GisTUuNpb15S3GbRwfa
// SIG // /SXfnXWIz6pzRH/XgdvzvfI2pMlcRdyvrT3gKGiXGqel
// SIG // cnNW8ReU5P01lHKg1nZfHndFg4U4FtBzWwW6Z1KNpbJp
// SIG // L9oZC/6SdCnidi9U3RQwWfjSjWL9y8lfRjFQuScT5EAw
// SIG // z3IpECgixzdOPaAyPZDNoTgGhVxOVoIoKgUyt0vXT2Pn
// SIG // 0i1i8UU956wIAPZGoZ7RW4wmU+h6qkryRs83PDietHdc
// SIG // pReejcsRj1Y8wawJXwPTAgMBAAGjggFeMIIBWjAPBgNV
// SIG // HRMBAf8EBTADAQH/MB0GA1UdDgQWBBTLEejK0rQWWAHJ
// SIG // Ny4zFha5TJoKHzALBgNVHQ8EBAMCAYYwEgYJKwYBBAGC
// SIG // NxUBBAUCAwEAATAjBgkrBgEEAYI3FQIEFgQU/dExTtMm
// SIG // ipXhmGA7qDFvpjy82C0wGQYJKwYBBAGCNxQCBAweCgBT
// SIG // AHUAYgBDAEEwHwYDVR0jBBgwFoAUDqyCYEBWJ5flJRP8
// SIG // KuEKU5VZ5KQwUAYDVR0fBEkwRzBFoEOgQYY/aHR0cDov
// SIG // L2NybC5taWNyb3NvZnQuY29tL3BraS9jcmwvcHJvZHVj
// SIG // dHMvbWljcm9zb2Z0cm9vdGNlcnQuY3JsMFQGCCsGAQUF
// SIG // BwEBBEgwRjBEBggrBgEFBQcwAoY4aHR0cDovL3d3dy5t
// SIG // aWNyb3NvZnQuY29tL3BraS9jZXJ0cy9NaWNyb3NvZnRS
// SIG // b290Q2VydC5jcnQwDQYJKoZIhvcNAQEFBQADggIBAFk5
// SIG // Pn8mRq/rb0CxMrVq6w4vbqhJ9+tfde1MOy3XQ60L/svp
// SIG // LTGjI8x8UJiAIV2sPS9MuqKoVpzjcLu4tPh5tUly9z7q
// SIG // QX/K4QwXaculnCAt+gtQxFbNLeNK0rxw56gNogOlVuC4
// SIG // iktX8pVCnPHz7+7jhh80PLhWmvBTI4UqpIIck+KUBx3y
// SIG // 4k74jKHK6BOlkU7IG9KPcpUqcW2bGvgc8FPWZ8wi/1wd
// SIG // zaKMvSeyeWNWRKJRzfnpo1hW3ZsCRUQvX/TartSCMm78
// SIG // pJUT5Otp56miLL7IKxAOZY6Z2/Wi+hImCWU4lPF6H0q7
// SIG // 0eFW6NB4lhhcyTUWX92THUmOLb6tNEQc7hAVGgBd3TVb
// SIG // Ic6YxwnuhQ6MT20OE049fClInHLR82zKwexwo1eSV32U
// SIG // jaAbSANa98+jZwp0pTbtLS8XyOZyNxL0b7E8Z4L5UrKN
// SIG // MxZlHg6K3RDeZPRvzkbU0xfpecQEtNP7LN8fip6sCvsT
// SIG // J0Ct5PnhqX9GuwdgR2VgQE6wQuxO7bN2edgKNAltHIAx
// SIG // H+IOVN3lofvlRxCtZJj/UBYufL8FIXrilUEnacOTj5XJ
// SIG // jdibIa4NXJzwoq6GaIMMai27dmsAHZat8hZ79haDJLmI
// SIG // z2qoRzEvmtzjcT3XAH5iR9HOiMm4GPoOco3Boz2vAkBq
// SIG // /2mbluIQqBC0N1AI1sM9MIIGBzCCA++gAwIBAgIKYRZo
// SIG // NAAAAAAAHDANBgkqhkiG9w0BAQUFADBfMRMwEQYKCZIm
// SIG // iZPyLGQBGRYDY29tMRkwFwYKCZImiZPyLGQBGRYJbWlj
// SIG // cm9zb2Z0MS0wKwYDVQQDEyRNaWNyb3NvZnQgUm9vdCBD
// SIG // ZXJ0aWZpY2F0ZSBBdXRob3JpdHkwHhcNMDcwNDAzMTI1
// SIG // MzA5WhcNMjEwNDAzMTMwMzA5WjB3MQswCQYDVQQGEwJV
// SIG // UzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMH
// SIG // UmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBv
// SIG // cmF0aW9uMSEwHwYDVQQDExhNaWNyb3NvZnQgVGltZS1T
// SIG // dGFtcCBQQ0EwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAw
// SIG // ggEKAoIBAQCfoWyx39tIkip8ay4Z4b3i48WZUSNQrc7d
// SIG // GE4kD+7Rp9FMrXQwIBHrB9VUlRVJlBtCkq6YXDAm2gBr
// SIG // 6Hu97IkHD/cOBJjwicwfyzMkh53y9GccLPx754gd6udO
// SIG // o6HBI1PKjfpFzwnQXq/QsEIEovmmbJNn1yjcRlOwhtDl
// SIG // KEYuJ6yGT1VSDOQDLPtqkJAwbofzWTCd+n7Wl7PoIZd+
// SIG // +NIT8wi3U21StEWQn0gASkdmEScpZqiX5NMGgUqi+YSn
// SIG // EUcUCYKfhO1VeP4Bmh1QCIUAEDBG7bfeI0a7xC1Un68e
// SIG // eEExd8yb3zuDk6FhArUdDbH895uyAc4iS1T/+QXDwiAL
// SIG // AgMBAAGjggGrMIIBpzAPBgNVHRMBAf8EBTADAQH/MB0G
// SIG // A1UdDgQWBBQjNPjZUkZwCu1A+3b7syuwwzWzDzALBgNV
// SIG // HQ8EBAMCAYYwEAYJKwYBBAGCNxUBBAMCAQAwgZgGA1Ud
// SIG // IwSBkDCBjYAUDqyCYEBWJ5flJRP8KuEKU5VZ5KShY6Rh
// SIG // MF8xEzARBgoJkiaJk/IsZAEZFgNjb20xGTAXBgoJkiaJ
// SIG // k/IsZAEZFgltaWNyb3NvZnQxLTArBgNVBAMTJE1pY3Jv
// SIG // c29mdCBSb290IENlcnRpZmljYXRlIEF1dGhvcml0eYIQ
// SIG // ea0WoUqgpa1Mc1j0BxMuZTBQBgNVHR8ESTBHMEWgQ6BB
// SIG // hj9odHRwOi8vY3JsLm1pY3Jvc29mdC5jb20vcGtpL2Ny
// SIG // bC9wcm9kdWN0cy9taWNyb3NvZnRyb290Y2VydC5jcmww
// SIG // VAYIKwYBBQUHAQEESDBGMEQGCCsGAQUFBzAChjhodHRw
// SIG // Oi8vd3d3Lm1pY3Jvc29mdC5jb20vcGtpL2NlcnRzL01p
// SIG // Y3Jvc29mdFJvb3RDZXJ0LmNydDATBgNVHSUEDDAKBggr
// SIG // BgEFBQcDCDANBgkqhkiG9w0BAQUFAAOCAgEAEJeKw1wD
// SIG // RDbd6bStd9vOeVFNAbEudHFbbQwTq86+e4+4LtQSooxt
// SIG // YrhXAstOIBNQmd16QOJXu69YmhzhHQGGrLt48ovQ7DsB
// SIG // 7uK+jwoFyI1I4vBTFd1Pq5Lk541q1YDB5pTyBi+FA+mR
// SIG // KiQicPv2/OR4mS4N9wficLwYTp2OawpylbihOZxnLcVR
// SIG // DupiXD8WmIsgP+IHGjL5zDFKdjE9K3ILyOpwPf+FChPf
// SIG // wgphjvDXuBfrTot/xTUrXqO/67x9C0J71FNyIe4wyrt4
// SIG // ZVxbARcKFA7S2hSY9Ty5ZlizLS/n+YWGzFFW6J1wlGys
// SIG // OUzU9nm/qhh6YinvopspNAZ3GmLJPR5tH4LwC8csu89D
// SIG // s+X57H2146SodDW4TsVxIxImdgs8UoxxWkZDFLyzs7BN
// SIG // Z8ifQv+AeSGAnhUwZuhCEl4ayJ4iIdBD6Svpu/RIzCzU
// SIG // 2DKATCYqSCRfWupW76bemZ3KOm+9gSd0BhHudiG/m4LB
// SIG // J1S2sWo9iaF2YbRuoROmv6pH8BJv/YoybLL+31HIjCPJ
// SIG // Zr2dHYcSZAI9La9Zj7jkIeW1sMpjtHhUBdRBLlCslLCl
// SIG // eKuzoJZ1GtmShxN1Ii8yqAhuoFuMJb+g74TKIdbrHk/J
// SIG // mu5J4PcBZW+JC33Iacjmbuqnl84xKf8OxVtc2E0bodj6
// SIG // L54/LlUWa8kTo/0xggSdMIIEmQIBATCBkDB5MQswCQYD
// SIG // VQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4G
// SIG // A1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0
// SIG // IENvcnBvcmF0aW9uMSMwIQYDVQQDExpNaWNyb3NvZnQg
// SIG // Q29kZSBTaWduaW5nIFBDQQITMwAAALARrwqL0Duf3QAB
// SIG // AAAAsDAJBgUrDgMCGgUAoIG2MBkGCSqGSIb3DQEJAzEM
// SIG // BgorBgEEAYI3AgEEMBwGCisGAQQBgjcCAQsxDjAMBgor
// SIG // BgEEAYI3AgEVMCMGCSqGSIb3DQEJBDEWBBQQuE1Ubxoh
// SIG // mGmXq6ZHwkagN/E0WTBWBgorBgEEAYI3AgEMMUgwRqAs
// SIG // gCoARQB2AGUAbgB0AHMAVABpAG0AZQBsAGkAbgBlAFYA
// SIG // aQBlAHcALgBqAHOhFoAUaHR0cDovL21pY3Jvc29mdC5j
// SIG // b20wDQYJKoZIhvcNAQEBBQAEggEApuI9uNCNSCrk72mt
// SIG // pLUKRiVy913WwUQSoomC+MOqGn0XAa6u5/DmtHh8Bvg3
// SIG // 2MRI6oerOykf+lotMCE9pe5jskmaD28g3fIgpoSB+aSl
// SIG // vEkMEgrPV+XaWlepNeAbVvx5xt1qDYtZqY5qbagNN4rs
// SIG // rueLmx438mEwAM9yI4Nq4Gy0VEaZYcH3eBLHt6mdPtB6
// SIG // tLaW4KrR7biG/aN3wwjzzjJcg9Ub80CJKbYWiqox5Zf7
// SIG // AoPscObuMH/qntqsA8uKkEp+7S6+AyI7xzPEouuyIT46
// SIG // lZfeawnUtGZIyldnwkxgBF+SyWxVfGByiddTtXCVov3u
// SIG // EA1azfGDi/sxnfcCs6GCAigwggIkBgkqhkiG9w0BCQYx
// SIG // ggIVMIICEQIBATCBjjB3MQswCQYDVQQGEwJVUzETMBEG
// SIG // A1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9u
// SIG // ZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9u
// SIG // MSEwHwYDVQQDExhNaWNyb3NvZnQgVGltZS1TdGFtcCBQ
// SIG // Q0ECEzMAAAArOTJIwbLJSPMAAAAAACswCQYFKw4DAhoF
// SIG // AKBdMBgGCSqGSIb3DQEJAzELBgkqhkiG9w0BBwEwHAYJ
// SIG // KoZIhvcNAQkFMQ8XDTEzMDMxNTA2MzQwMlowIwYJKoZI
// SIG // hvcNAQkEMRYEFGd9G9Mbi0ZfH1DDmfqeSE0YK3qkMA0G
// SIG // CSqGSIb3DQEBBQUABIIBAISxGFhomFf+S5+LJTUbWyVu
// SIG // SqVfPcxO0bcwULKj2JvwFExuDIdujgXfC160QoVLuOHa
// SIG // 0QI40/d+Uxzl+bQTcVdgSqFfruTzOvh3fsKvDA+OZAop
// SIG // ZxJaihR4e+cQxgwr9CDV7NSh3iRRiGbsUCQS24vhImWu
// SIG // RDvtlfOBIOWcYCwuui9zUbIav3cXTcG9oL3pon2ntS81
// SIG // wRrpHswkD3zvtrHV+H8p4VqepglQ7iGjqdQV2r5zmWpl
// SIG // afYwstHIV+Yui1MxjlX+8mOkb2f11sxDzC2vv/m1Fa/F
// SIG // S9QaFv1afoMbNBWhf86J8Ix14C+RjorNwFh57w++RBDh
// SIG // bR01UviYC6c=
// SIG // End signature block
